﻿//////////////////////////////////////////////
// KeyboardDeviceManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkInputs
{
	class System ;
}

/// Includes ---------------------------------

// nkInputs
#include "../../Dll/DllDefines.h"

#include "MouseDevice.h"

// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

// nkMemory
#include <NilkinsMemory/Containers/StringView.h>

#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <unordered_map>
#include <string>

/// Class ------------------------------------

namespace nkInputs
{
	class DLL_INPUTS_EXPORT MouseDeviceManager final : public nkCommon::MaybeSingletonClass<MouseDeviceManager>
	{
		public :

			// Getters
			System* getSystem () const ;

			// Memory Management
			MouseDevice* createOrRetrieve (nkMemory::StringView name) ;
			MouseDevice* record (nkMemory::StringView name, nkMemory::UniquePtr<MouseDevice> device) ;
			MouseDevice* get (nkMemory::StringView name) const ;
			MouseDevice* getByIndex (unsigned int index) const ;
			void rename (nkMemory::StringView currentName, nkMemory::StringView newName) ;
			void erase (nkMemory::StringView name) ;
			nkMemory::UniquePtr<MouseDevice> relinquish (nkMemory::StringView name) ;

		private :

			// Functions
			// Constructor, destructor
			MouseDeviceManager (bool isSingleton) noexcept ;
			MouseDeviceManager (System* system) noexcept  ;
			MouseDeviceManager (const MouseDeviceManager&) = delete ;

			// Operators
			MouseDeviceManager operator= (const MouseDeviceManager&) = delete ;

		private :

			// Attributes
			// Memory
			std::unordered_map<std::string, nkMemory::UniquePtr<MouseDevice>> _devices ;
			System* _system ;

		private :

			friend class nkCommon::MaybeSingletonClass<MouseDeviceManager> ;
			friend class System ;
	} ;
}